<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


class Ultimate_AI_Stripe{
    public $stripe, $payment_data, $UAI_PAYMENTS;
    public function __construct(){
        $this->UAI_PAYMENTS = new Ultimate_AI_Payments_Module();

        if( !$this->UAI_PAYMENTS->gateway_active('stripe') ) return;

        $this->InitStripeClient();
    }
    
    public function create_checkout( $data ){
        $this->payment_data = $data;
        return $this->createCheckoutSession();
    }

    public function CreateOrderData( $session_id, $pricing_id ){
        
        $session = $this->stripe->checkout->sessions->retrieve($session_id);
        $customer = $this->stripe->customers->retrieve($session->customer);

        $SUBSCRIPTION_MANAGER = new Ultimate_AI_Subscription();

        $package_type = $SUBSCRIPTION_MANAGER->getPackageType( $pricing_id );

        $current_user = wp_get_current_user();

        if( $package_type == 'subscription' ){
            $order = [
                'subscribed'        => true,
                'order_id'          => $session->subscription, //stripe subscription id
                'subscription_id'   => $session->subscription, //stripe subscription id
                'user_id'           => get_current_user_id(),
                'name'              => $current_user->display_name,
                'email'             => $current_user->user_email,
                'address'           => $customer->address,
                'customer_id'       => $customer->id,
                'starts'            => $customer->subscriptions->data[0]->current_period_start,
                'expiry'            => $customer->subscriptions->data[0]->current_period_end,
                'payment_method_id' => $customer->subscriptions->data[0]->default_payment_method,
                'payment_method'    => 'stripe',
                'plan_price'        => $customer->subscriptions->data[0]->plan->amount_decimal/100,
                'plan_stripe_id'    => $customer->subscriptions->data[0]->plan->id,
                'pricing_id'        => $pricing_id,
                'payment_status'    => $customer->subscriptions->data[0]->status,
                'country'           => $customer->address->country,
                'currency'          => $customer->subscriptions->data[0]->currency,
              ];
        }elseif( $package_type == 'token' ){
            $order = [
                'subscribed'        => true,
                'order_id'          => $session->payment_intent,
                'user_id'           => get_current_user_id(),
                'name'              => $current_user->display_name,
                'email'             => $current_user->user_email,
                'address'           => $customer->address,
                'customer_id'       => $customer->id,
                'starts'            => time(),
                'expiry'            => 'Unlimited',
                'payment_method'    => 'stripe',
                'plan_price'        => $SUBSCRIPTION_MANAGER->getpackagePrice( $pricing_id ),
                'pricing_id'        => $pricing_id,
                'payment_status'    => 'active',
                'country'           => $customer->address->country,
                'currency'          => $SUBSCRIPTION_MANAGER->getDefaultCurrency(),
            ];
        }
        return $order;
    }

    public function createCheckoutSession(){
        $args = [
          'success_url' => $this->UAI_PAYMENTS->createSuccessUrl('stripe', $this->payment_data['pricing_id']),
          'cancel_url' => $this->UAI_PAYMENTS->getDashboardUrl('pricing'),
        ];
  
        if( $this->payment_data['package'] == 'token' ){
          $args['line_items'] = [
            [
              'price_data' => [
                'currency' => 'USD',
                'unit_amount' => (int) $this->payment_data['price'] * 100,
                'product_data' => [
                  'name' => "Payment for " . $this->payment_data['name']
                ]
              ],
              'quantity' => 1,
            ],
          ];
  
          $args['mode'] = 'payment';
        }else{
          $args['line_items'] = [
            [
              'price' => $this->payment_data['stripe_product_id'],
              'quantity' => 1,
            ],
          ];
  
          $args['mode'] = 'subscription';
        }
        try{
          $checkout_session = $this->stripe->checkout->sessions->create( $args );
          return [
            'status' => 200,
            'message' => 'Chckout Session created!',
            'url' => $checkout_session->url,
          ];
        }catch( Exception $e ){
          return [
            'status' => 401,
            'message' => 'Error chckout, ' . $e->getError()->message,
            'url' => null,
          ];
        }
    
    }

    public function createProduct( $plan_name ){

      try{
        $created_product = $this->stripe->products->create([ 'name' => $plan_name ]);
        return [
          'status' => 200,
          'message' => 'Product created!',
          'product_id' => $created_product->id,
        ];
      }catch( Exception $e ){
        return [
          'status' => 401,
          'message' => 'Product creation failed, ' . $e->getError()->message,
          'product_id' => null,
        ];
      }
    }
    public function updateProduct( $plan_name, $prod_id ){
      try{
        $updated_prduct = $this->stripe->products->update(
          $prod_id,
          [ 'name' => $plan_name ]
        );
        return [
          'status' => 200,
          'message' => 'Product created!',
          'product_id' => $prod_id,
        ];
      }catch( Exception $e ){
        return [
          'status' => 401,
          'message' => 'Product creation failed, ' . $e->getError()->message,
          'product_id' => null,
        ];
      }
    }

    public function createPricing( $data, $currency ){
      $created_pricing = [];
      // if( !$this->UAI_PAYMENTS->gateway_active('stripe') ) return $created_pricing;

      foreach( $data['pricing'] as $key => $val ){
        foreach( $val['schemes'] as $k => $scheme ){
          if( !isset( $scheme['stripe_key'] ) || empty( $scheme['stripe_key'] ) ){
            $pricing_obj = $this->stripe->prices->create([
              'currency' => $currency,
              'unit_amount' => (int) $scheme['price'] * 100,
              'unit_amount' => $this->UAI_PAYMENTS->calculate_price($scheme['price'], $scheme['discount'], $scheme['discount_method'] ) * 100,
              'recurring' => 
                [
                  'interval' => $scheme['type'] == 'monthly' ? 'month' : 'year'
                ],
              'product' => $data['stripe_product_id'],
            ]);
            $created_pricing[$key][$scheme['type']] = $pricing_obj->id;         
          }else{
            $created_pricing[$key][$scheme['type']] = $data['pricing'][$key]['schemes'][$k]['stripe_key'];
          }
        }
      }

      return $created_pricing;
    }

    public function cancelSubscription( $subscription_id ){
      try{
        $cancel = $this->stripe->subscriptions->cancel( $subscription_id , []);
        return [
          'status' => 200,
          'message' => 'Subscription cancel success!',
          'id' => $cancel->id,
        ];
      }catch( Exception $e ){
        return [
          'status' => 401,
          'message' => 'Error cancelling subscription, ' . $e->getError()->message,
          'id' => null,
        ];
      }
    }

    public function get_secret_key(){
      $payment_methods = get_option( 'ultimate_ai_payment_method', [] );
      $gateway = $payment_methods['stripe']['gateway'];
      return $payment_methods['stripe'][$gateway]['api_secret'];
    }
    
    public function InitStripeClient(){
      
      if($this->get_secret_key() != ''){
        $this->stripe = new \Stripe\StripeClient($this->get_secret_key());
      }
  }
}